define([],
	function() {
		var noteTooltipController = function(
			$scope,
			$position,
			tooltipGenerator
		) {
			var self = this;
			this.tooltip = tooltipGenerator

			this.show = function(event, description) {
				var position = $position.offset(angular.element(event.currentTarget))

				self.tooltip
					.addClass('info note swift')
					.setDistance(10)
					.setOrientation('top')
					.setContent('<div class="body"><span>' + description.toString() + '</span></div>')
					.setPosition([
						position.left + position.width / 2,
						position.top
					])
					.create()
			}

			this.hide = function(event) {
				self.tooltip.remove()
			}
		}

		return noteTooltipController;
	}
)