define([
	],
	function() {
		var selectionController = function(
			$scope,
			$q,
			services
		) {
			var self = this;

			this.isValid = function() {
				var inRing = $scope.host.isPartOfRing(self.getFirstItem(), self.group)

				return _.every(self.asArray(), function(item) {
					return $scope.host.isPartOfRing(item, self.group) === inRing
				})
			}

			this.getFirstItem = function() {
				return _.first(self.asArray());
			}

			this.asArray = function() {
				if(_.isArray(self.items)) {
					return self.items;
				} else {
					return [self.items];
				}
			}

			this.getAttr = function(attr) {
				return _.pluck(self.asArray(), attr);
			}

			this.init= function(arr, group) {
				self.items = arr
				self.group = group
				self.status = 'NORMAL'
			}
		}

		return selectionController;
	}
)