define([
	],
	function() {
		var serviceController = function(
			$scope,
			$q,
			services
		) {
			var self = this;

			this.processAction = function(local, service, current) {
				var servicesURL = ([
					'http:/',
					self.hostIP,
					'swift_init',
					service,
					current === 'running' ? 'stop' : 'start'
				]).join('/');

				services.setEndpoint(servicesURL)
					.post({}).then(function(result) {
						local.mode = 'NORMAL';
					})
			}

			this.select = function(local) {
				if(local.mode === 'NORMAL') {
					local.mode = 'CONFIRM';
				}
			}

			this.cancel = function(local) {
				local.mode = 'NORMAL';
			}

			this.init = function(host, group) {
				host.loading = true;
				self.hostIP = host.ip

				var servicesURL = ([
					'http:/',
					host.ip,
					'swift_init',
					'all'
				]).join('/');
				$q.all([
					services.setEndpoint(servicesURL)
						.get(),
				]).then(function(results) {
					var services = results[0].data
					self.services = services;

					host.loading = false;
				})
			}
		}

		return serviceController;
	}
)