define([],
	function() {
		var templateController = function(
			$scope,
			DRIVE_TEMPLATES
		) {
			var self = this;

			this.getActiveDrives = function(drives) {
				return _.chain(drives)
					.filter('active', true)
					.pluck('name')
					.value()
			}

			this.templates = _.map(DRIVE_TEMPLATES, function(drives, ring) {
				return {
					name: ring,
					drives: _.map(drives, function(drive) {
						return {
	 						name: drive,
							active: true
						}
					}),
				}
			});
		}

		return templateController;
	}
)