define([
		'text!partials/swift.tooltip.utilization.html',
	],
	function(swiftTooltipUtilizationPartial) {
		var utilTooltipController = function(
			$scope,
			$position,
			tooltipGenerator
		) {
			var self = this;
			this.tooltip = tooltipGenerator;

			this.show = function(event, host, health) {
				var context = {
					host: host,
					health: health,
				}
				var position = $position.offset(angular.element(event.currentTarget).find('.bar'))

				self.tooltip
					.addClass('info util swift')
					.setContent(swiftTooltipUtilizationPartial)
					.setDistance(15)
					.setOrientation('top')
					.setContext(context)
					.setPosition([
						position.left + position.width,
						position.top
					])
					.create()
			}

			this.hide = function(event) {
				self.tooltip.remove()
			}
		}

		return utilTooltipController;
	}
)