define([
		'lodash/lodash',
	],
	function(_) {
		var infiniScrollDirective = function() {
			return {
				scope: {
					max: '@',
					rate: '@',
					threshold: '@',
					current: '=',
				},
				restrict: 'A',
				link: function(scope, element, attrs) {
					element.on('wheel DOMMouseScroll', function(e) {
				        var containerHeight = element.outerHeight();
				        var contentHeight = element[0].scrollHeight;

						var curScrollPos = element.scrollTop();
						var wheelEvent = e.originalEvent;
						var dY = e.originalEvent.deltaY ||
							(e.originalEvent.wheelDelta / -40) ||
							e.originalEvent.detail;

						if(curScrollPos >= (contentHeight - containerHeight) * parseFloat(scope.threshold)) {
							if(dY > 0) {
								if(scope.current <= parseInt(scope.max, 10)) {
									scope.$apply(function() {
										scope.current = Math.min(parseFloat(scope.max, 10), scope.current + parseFloat(scope.rate, 10))
									})
								}

								if(curScrollPos >= contentHeight - containerHeight) {
									return false
								}
							}
						} else if(dY < 0 && curScrollPos <= 0) {
							return false
						}
					})

					scope.$on('$destroy', function() {
					    element.off('wheel DOMMouseScroll')
					});
				}
			};
		}

		return infiniScrollDirective;
	}
)