define([
		'lodash/lodash',
	],
	function(_) {
		var trapScrollDirective = function() {
			return {
				restrict: 'A',
				link: function(scope, element, attrs) {
					element.on('wheel DOMMouseScroll', function(e) {
				        var containerHeight = element.outerHeight();
				        var contentHeight = element[0].scrollHeight;

						var curScrollPos = element.scrollTop();
						var wheelEvent = e.originalEvent;
						var dY = e.originalEvent.deltaY ||
							(e.originalEvent.wheelDelta / -40) ||
							e.originalEvent.detail;

				        if ((dY > 0 && curScrollPos >= contentHeight - containerHeight) ||
				          (dY < 0 && curScrollPos <= 0)) {
				          return false;
				        }
					})

					scope.$on('$destroy', function() {
					    element.off('wheel DOMMouseScroll')
					});
				}
			};
		}

		return trapScrollDirective;
	}
)