define([
    	'jquery/jquery-2.1.3',
		'lodash/lodash',
	],
	function(jQuery, _) {
		var windowClick = function($window, $timeout) {
			return {
				restrict: 'A',
				scope: {
					callback: "&",
                },
				link: function(scope, element, attrs) {
                    var unique = _.uniqueId('window_');
                    var eventId = (['click', unique]).join('.');

					$timeout(function() {
                        angular.element($window).on(eventId, function(event) {
                            if(event && !element[0].contains(event.target)) {
                                scope.$apply(function() {
                                    scope.callback({event: event})
                                })
                            }
    					})
					})

					scope.$on('$destroy', function() {
					    angular.element($window).off(eventId)
					});
				}
			};
		}

		return windowClick;
	}
)