define([
	'angular/angular',
	'angular/angular-animate',

	'app/modules/swiftConstants',
	'app/modules/swiftTooltip',
	'app/services/dataResource',

	'app/controllers/driveCreationController',
	'app/controllers/dashboardController',
	'app/controllers/dataController',
	'app/controllers/hostController',
	'app/controllers/templateController',
	'app/controllers/serviceController',
	'app/controllers/clickController',
	'app/controllers/selectionController',

	'text!partials/swift.expansion.device.html',
	'text!partials/swift.expansion.service.html',
	'text!partials/swift.expansion.template.html',
], function(
	ng,
	ngAnimate,
	swiftConstants,
	swiftTooltip,
	dataResource,

	driveCreationController,
	dashboardController,
	dataController,
	hostController,
	templateController,
	serviceController,
	clickController,
	selectionController,

	devicePartial,
	servicePartial,
	templatePartial
	) {
		angular.module('swift.data', [
			'ngAnimate',
			'swift.constants',
			'swift.tooltip'
		])
			.factory('hosts', ['$q', '$http', 'CENTRAL_API_URL', function($q, $http, CENTRAL_API_URL) {
				return new dataResource(
					$q,
					$http,
					{
						endpoint: '/hosts'
						// endpoint: [CENTRAL_API_URL, 'hosts'].join('/')
					}
				)
			}])
			.factory('health', ['$q', '$http', 'CENTRAL_API_URL', function($q, $http, CENTRAL_API_URL) {
				return new dataResource(
					$q,
					$http,
					{
						endpoint: '/health'
						// endpoint: [CENTRAL_API_URL, 'health'].join('/')
					}
				)
			}])
			.factory('redis', ['$q', '$http', 'CENTRAL_API_URL', function($q, $http, CENTRAL_API_URL) {
				return new dataResource(
					$q,
					$http,
					{
						endpoint: '/redis'
						// endpoint: [CENTRAL_API_URL, 'redis'].join('/')
					}
				)
			}])
			.factory('drives', ['$q', '$http', 'CENTRAL_API_URL', function($q, $http, CENTRAL_API_URL) {
				return new dataResource(
					$q,
					$http,
					{
						endpoint: '/drive'
						// endpoint: [CENTRAL_API_URL, 'drives'].join('/')
					}
				)
			}])
			.factory('rings', ['$q', '$http', 'CENTRAL_API_URL', function($q, $http, CENTRAL_API_URL) {
				return new dataResource(
					$q,
					$http,
					{}
				)
			}])
			.factory('devices', ['$q', '$http', function($q, $http) {
				return new dataResource(
					$q,
					$http,
					{}
				)
			}])
			.factory('mounts', ['$q', '$http', function($q, $http) {
				return new dataResource(
					$q,
					$http,
					{}
				)
			}])
			.factory('services', ['$q', '$http', function($q, $http) {
				return new dataResource(
					$q,
					$http,
					{}
				)
			}])

			.factory('update', ['$q', '$http', function($q, $http) {
				return new dataResource(
					$q,
					$http,
					{}
				)
			}])

			.controller('driveCreationController', [
				'$scope',
				'$modal',
				'$q',
				'drives',
				driveCreationController])

			.controller('dashboardController', [
				'$scope',
				dashboardController])

			.controller('dataController', [
				'$scope',
				'$q',
				'$timeout',
				'hosts',
				'health',
				'redis',
				'rings',
				'RING_TYPES',
				'CENTRAL_API_URL',
				dataController])

			.controller('hostController', [
				'$scope',
				'$q',
				'$timeout',
				'update',
				'devices',
				'mounts',
				'CENTRAL_API_URL',
				'RING_TYPES',
				hostController])

			.controller('clickController', [
				'$scope',
				'$document',
				'$timeout',
				'$animate',
				'$position',
				'smoothScroll',
				clickController])

			.controller('templateController', [
				'$scope',
				'DRIVE_TEMPLATES',
				templateController])

			.controller('serviceController', [
				'$scope',
				'$q',
				'services',
				serviceController])

			.controller('selectionController', [
				'$scope',
				'$q',
				selectionController])

			.run(["$templateCache", function($templateCache) {
				$templateCache.put("swift.expansion.device.html", devicePartial);
				$templateCache.put("swift.expansion.service.html", servicePartial);
				$templateCache.put("swift.expansion.template.html", templatePartial);
			}]);
})