define([
	'angular/angular',
	'angular/angular-animate',
	'angular/angular-sanitize',
	'angular-ui/angular-ui',
	'app/services/tooltip',
], function(
	ng,
	ngAnimate,
	ngSanitize,
	angularUI,
	tooltip
	) {
		angular.module("utility.tooltip", ['ngSanitize', 'ngAnimate'])

			.factory('tooltipGenerator', [
				'$document',
				'$animate',
				'$q',
				'$compile',
				'$interpolate',
				'$timeout',
				'$templateCache',
				'$rootScope',
				function($document,
					$animate,
					$q,
					$compile,
					$interpolate,
					$timeout,
					$templateCache,
					$rootScope
				) {
					return new tooltip($document,
						$animate,
						$q,
						$compile,
						$interpolate,
						$timeout,
						$templateCache,
						$rootScope)
			}])

			.run(["$templateCache", function($templateCache) {
			  $templateCache.put("tameka.tooltip.template.html",
			    "<div class=\"tooltip {{placement}} {{classes}} tameka-animate\">\n" +
			    "  <div class=\"tooltip-arrow\"></div>\n" +
			    "  <div class=\"tooltip-inner\" ng-bind-html=\"content\"></div>\n" +
			    "</div>\n" +
			    "");
			}]);
	});