package main

import (
	"bufio"
	"fmt"
	"log"
	"net/http"
	"os"
	"time"
)

const (
	clueUnhostEndpoint = "http://clue-internal.production.us-west2.twitch.tv:6100/internal/users/%s/hosting"
)

func main() {
	f, err := os.Open("../live_hosting.log")
	if err != nil {
		log.Fatal(err)
	}
	defer f.Close()

	client := &http.Client{}

	scanner := bufio.NewScanner(f)
	for scanner.Scan() {
		channelId := scanner.Text()
		fmt.Println(channelId)

		if channelId == "" || channelId == "0" {
			continue
		}

		// clear the live channel's host status
		clueUrl := fmt.Sprintf(clueUnhostEndpoint, channelId)
		fmt.Printf("calling clue at %v\n", clueUrl)
		req, err := http.NewRequest(http.MethodDelete, clueUrl, nil)
		if err != nil {
			log.Print(err)
			continue
		}

		res, err := client.Do(req)
		if err != nil {
			log.Print(err)
			continue
		}

		if res.StatusCode != http.StatusOK {
			log.Printf("could not delete host for channel %v\n", channelId)
		} else {
			log.Printf("deleted host for channel %v\n", channelId)
		}

		res.Body.Close()
		time.Sleep(100 * time.Millisecond)
	}

	if err := scanner.Err(); err != nil {
		log.Fatal(err)
	}
}
