#!/bin/bash
# Build and push the go builder image

# Build args
GO_SHA256=72d820dec546752e5a8303b33b009079c15c2390ce76d67cf514991646c6127b
GO_VERSION=1.10.1
DEP_VERSION=0.4.1
METALINTER_VERSION=2

# Build image name
REPO=docker.internal.justin.tv
TEAM=hygienic
IMAGE_NAME=gobuilder
# Version is made of two parts: The go version, and an incrementing version that changes with the dependencies
METAVERSION=0

FULL_DOCKER_NAME=$REPO/$TEAM/$IMAGE_NAME:$GO_VERSION-$METAVERSION

docker build --build-arg METALINTER_VERSION=$METALINTER_VERSION --build-arg DEP_VERSION=$DEP_VERSION --build-arg GO_SHA256=$GO_SHA256 --build-arg GO_VERSION=$GO_VERSION -t $FULL_DOCKER_NAME .
docker push $FULL_DOCKER_NAME
