locals {
  owner   = "jlindamo@twitch.tv"
  team    = "hygienic"
  region  = "us-west-2"
  service = "dynamocursor-testing"

  lsi_name   = "lsi_1"
  gsi_name   = "gsi_1"
  profile    = "twitch-feed-dev"
  account_id = "724951484461"
}

provider "aws" {
  profile             = "${local.profile}"
  allowed_account_ids = ["${local.account_id}"]
  region              = "${local.region}"
}

terraform {
  backend "s3" {
    bucket  = "twitch-feed-dev"
    key     = "hygienic/dynamocursor-testing-us-west-2.tfstate"
    region  = "us-west-2"
    profile = "twitch-feed-dev"
  }
}

resource "aws_dynamodb_table" "test_table" {
  name           = "${local.service}_integration_query_table"
  read_capacity  = "10"
  write_capacity = "10"

  // One user ID can have multiple aliases
  hash_key  = "user_id"
  range_key = "alias"

  attribute {
    name = "user_id"
    type = "N"
  }

  attribute {
    name = "alias"
    type = "S"
  }

  attribute {
    name = "alias_key"
    type = "B"
  }

  // Index of which users have an alias
  global_secondary_index {
    name            = "${local.gsi_name}"
    projection_type = "ALL"
    hash_key        = "alias"
    range_key       = "user_id"
    read_capacity   = "10"
    write_capacity  = "10"
  }

  // Reverse lookup for the alias key by user
  local_secondary_index {
    name            = "${local.lsi_name}"
    projection_type = "ALL"
    range_key       = "alias_key"
  }

  tags {
    Environment = "integration"
    Service     = "${local.service}"
    Team        = "${local.team}"
  }
}

resource local_file "file" {
  content = <<EOF
{
  "table_name": "${aws_dynamodb_table.test_table.name}",
  "gsi_name": "${local.gsi_name}",
  "region": "${local.region}",
  "profile": "${local.profile}",
  "lsi_name": "${local.lsi_name}"
}
EOF

  filename = "test_info.json"
}
