# example
[![GoDoc](https://img.shields.io/badge/godoc-reference-5272B4.svg?style=flat-square)](https://godoc.internal.justin.tv/code.justin.tv/hygienic/example)
[![Build Status](https://jenkins.internal.justin.tv/buildStatus/icon?job=hygienic/example/master)](https://jenkins.internal.justin.tv/job/hygienic/job/example/job/master/)

Example is an example repository.  It describes how any repository in hygienic should act.

# Code standard

Every library in hygienic should defer to the coding standards outlined in these posts.  Exceptions exist, but should
be strongly reasoned.

* [Aspects of a good go library](https://medium.com/@cep21/aspects-of-a-good-go-library-7082beabb403)
* [Effective Go](https://golang.org/doc/effective_go.html)
* [Go Code review comments list](https://github.com/golang/go/wiki/CodeReviewComments)
* [Go proverb](https://go-proverbs.github.io/)

# Go libraries only

This is intended to be a repository of libraries only.  Executables should go somewhere else, but can move their
library code here.

# Files
Every repository should have these minimal files

## README.md

A readme file with badges linking to the documentation and build status, at a minimum.  Should also contain a minimum
sentence explaining in broad terms what the library does.

## go.mod
Uses modules to manage dependencies

## Makefile

Makefiles are the standard way to interact with the library.  It should contain the follow three subcommands.  It can
also contain another subcommand, `make fix` as a convenience that runs `go fmt` and `goimports` on the code in the
repository.

### make format
Reformat code

### make build
Build the dockerfile for this library, applying any static checks

## Jenkinsfile

A Jenkinsfile controls how your library is verified by CI.  It should be enough to include the one inside this repository.

## No /vendor folder

Since this is for libraries only, do not check in your /vendor folder

# Go version

Your code should work with the latest release version of Go.  Given Go's
[compatability promise](https://golang.org/doc/go1compat), this isn't difficult to do.  There's no requirement on how many
versions of Go backwards your code should work with.

# Code coverage

Requirements for non zero functional code coverage are on hold until 1.10 is released with better code coverage support.

# Setting up new repositories

To setup a new project, copy the common files listed above for the example.  You don't need to setup a Jenkins webhook:
this is configured at the project level `git-aws.internal.justin.tv/hygienic` so any repository under hygienic will
be fine.
