package gometrics

import (
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestService(t *testing.T) {
	statter := &sender{}
	service := &Service{
		Statter:  statter,
		Interval: time.Millisecond,
	}

	require.NoError(t, service.Setup(), "setup")

	done := make(chan struct{})
	go func() {
		defer close(done)
		err := service.Start()
		require.NoError(t, err, "start")
	}()

	time.Sleep(5 * time.Millisecond)

	require.NoError(t, service.Close(), "closing")
	<-done

	assert.True(t, statter.hasGauge("go.num_goroutines"))
	assert.True(t, statter.hasCounter("go.mem.mallocs"))
	assert.True(t, statter.hasCounter("go.mem.frees"))
	assert.True(t, statter.hasGauge("go.mem.sys"))
	assert.True(t, statter.hasGauge("go.mem.alloc"))
	assert.True(t, statter.hasCounter("go.gc.collections"))
	assert.True(t, statter.hasGauge("go.gc.percent_cpu"))
	assert.True(t, statter.hasTiming("go.gc.last_duration"))
	assert.True(t, statter.hasTiming("go.gc.total_duration"))
	assert.True(t, statter.hasGauge("go.mem.heap_objects"))
	assert.True(t, statter.hasGauge("go.mem.heap.sys"))
	assert.True(t, statter.hasGauge("go.mem.heap.idle"))
	assert.True(t, statter.hasGauge("go.mem.heap.inuse"))
	assert.True(t, statter.hasGauge("go.mem.heap.released"))
	assert.True(t, statter.hasGauge("go.mem.stack.sys"))
	assert.True(t, statter.hasGauge("go.mem.stack.inuse"))
	assert.True(t, statter.hasGauge("go.mem.mspan.sys"))
	assert.True(t, statter.hasGauge("go.mem.mcache.sys"))
	assert.True(t, statter.hasGauge("go.mem.buckhash.sys"))
	assert.True(t, statter.hasGauge("go.mem.other.sys"))
}

type sender struct {
	counters []string
	gauges   []string
	timings  []string
}

func (s *sender) Inc(m string, v int64, r float32) error {
	s.counters = append(s.counters, m)
	return nil
}

func (s *sender) Gauge(m string, v int64, r float32) error {
	s.gauges = append(s.gauges, m)
	return nil
}

func (s *sender) TimingDuration(m string, v time.Duration, r float32) error {
	s.timings = append(s.timings, m)
	return nil
}

func (s *sender) hasCounter(m string) bool {
	return hasString(s.counters, m)
}

func (s *sender) hasGauge(m string) bool {
	return hasString(s.gauges, m)
}

func (s *sender) hasTiming(m string) bool {
	return hasString(s.timings, m)
}

func hasString(s []string, v string) bool {
	for _, t := range s {
		if t == v {
			return true
		}
	}
	return false
}
