#!/usr/bin/groovy
package tv.justin.hygienic;
import groovy.transform.Field

@Field String builderImage = 'docker.internal.justin.tv/hygienic/gobuilder:1.10.1-0'

def checkout() {
	stage ("Checkout") {
	  // https://stackoverflow.com/questions/45348629/is-there-a-way-to-run-a-pre-checkout-step-in-declarative-jenkins-pipelines
	  deleteDir()
    scmInfo = checkout scm
		parts = env.JOB_NAME.tokenize('/')
		org = parts[0]
		app = parts[1]
		orgApp = parts[0] + "/" + parts[1]
		env.GIT_COMMIT = scmInfo.GIT_COMMIT
	}
}

// Runs the command in a stage inside the docker file, forwarding SSH socket information
def builder_run(stageName, command) {
  stage(stageName) {
    sshagent (credentials: ['git-aws-read-key']) {
      sh 'docker run -w /go/src/code.justin.tv/' + orgApp + ' --volume ${SSH_AUTH_SOCK}:${SSH_AUTH_SOCK}:ro --env GIT_COMMIT=$GIT_COMMIT --env SSH_AUTH_SOCK=$SSH_AUTH_SOCK -v `pwd`:/go/src/code.justin.tv/' + orgApp + ' ' + builderImage + ' ' + command
    }
  }
}

def checkout_dependencies() {
  builder_run("Checking out dependencies", "make deps")
}

def run_tests() {
  builder_run("Running tests", "make test")
}

def run_lints() {
  builder_run("Linting code", "make lint")
}

def defaultPipeline() {
  checkout()
  checkout_dependencies()
  parallel (
    "lints": {
      run_lints()
    },
    "tests": {
      run_tests()
    }
  )
}
