package loglogrus

import (
	"testing"

	"code.justin.tv/hygienic/log"
)

func TestLog(t *testing.T) {
	l := Log{
		Level:  FatalLevel,
		Logger: log.Panic,
	}
	// Should not panic
	l.Info("hello")

	foundPanic := false
	func() {
		defer func() {
			if r := recover(); r != nil {
				foundPanic = true
			}
		}()
		l.Fatal("this should panic")
	}()
	if !foundPanic {
		t.Error("Expected a panic")
	}

}
