# rlimit

Package rlimit exposes a `Var()` method that can be used to report values returned buy getrlimit(2) as expvar metrics.

## Motivation

As we move more towards ECS and docker, we need a way to verify that our Cloudformation/Terraform settings for containers are actually applied to running containers.
Utilizing this library makes it easy to expose statistics like current number of file descriptors the process can create. For a full list of stats that are supported see the Example Output below.

The man page for [getrlimit(2)](http://man7.org/linux/man-pages/man2/getrlimit.2.html) has more info on the meaning of each statistic.
## Usage
~~~go
  // This is how rlimit is integrated into graphdb.
	f.serviceCommon.ExpvarHandler.Exported["rlimit"] = rlimit.Var()
~~~

## Example Output
~~~sh
{
  "rlimit": {
    "no_file": {
      "Cur": 4864,
      "Max": 9223372036854776000
    },
    "stack": {
      "Cur": 67104768,
      "Max": 67104768
    },
    "core": {
      "Cur": 0,
      "Max": 9223372036854776000
    },
    "cpu": {
      "Cur": 9223372036854776000,
      "Max": 9223372036854776000
    },
    "file_size": {
      "Cur": 9223372036854776000,
      "Max": 9223372036854776000
    },
    "data": {
      "Cur": 9223372036854776000,
      "Max": 9223372036854776000
    },
    "as": {
      "Cur": 9223372036854776000,
      "Max": 9223372036854776000
    }
  }
}
~~~
