package rlimit

import (
	"encoding/json"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func TestRLimit(t *testing.T) {
	Convey("get expvar value of rlimit", t, func(c C) {
		rlimitVal := Var()
		v := rlimitVar{}
		err := json.Unmarshal([]byte(rlimitVal.String()), &v)
		Convey("expvar value should be in json form", func(c C) {
			So(err, ShouldBeNil)
		})
		Convey("expvar.Error should be empty", func(c C) {
			So(v.Error, ShouldEqual, "")
		})
		Convey("expvar.NoFile should not be empty", func(c C) {
			So(v.NoFile.Max, ShouldBeGreaterThan, 0)
			So(v.NoFile.Cur, ShouldBeGreaterThan, 0)
		})
		Convey("expvar.Stack should not be empty", func(c C) {
			So(v.Stack.Max, ShouldBeGreaterThan, 0)
			So(v.Stack.Cur, ShouldBeGreaterThan, 0)
		})
		Convey("expvar.Core should not be empty", func(c C) {
			So(v.Core.Max, ShouldBeGreaterThan, 0)
			// Note: v.Core.Cur can be 0 legitimately.
		})
		Convey("expvar.CPU should not be empty", func(c C) {
			So(v.CPU.Max, ShouldBeGreaterThan, 0)
			So(v.CPU.Cur, ShouldBeGreaterThan, 0)
		})
		Convey("expvar.FileSize should not be empty", func(c C) {
			So(v.FileSize.Max, ShouldBeGreaterThan, 0)
			So(v.FileSize.Cur, ShouldBeGreaterThan, 0)
		})
		Convey("expvar.Data should not be empty", func(c C) {
			So(v.Data.Max, ShouldBeGreaterThan, 0)
			So(v.Data.Cur, ShouldBeGreaterThan, 0)
		})
		Convey("expvar.AddressSpace should not be empty", func(c C) {
			So(v.AddressSpace.Max, ShouldBeGreaterThan, 0)
			So(v.AddressSpace.Cur, ShouldBeGreaterThan, 0)
		})
	})
}
