package servicerunner

import (
	"os"
	"testing"
)

type exampleService struct {
	ch   chan os.Signal
	wait chan struct{}
}

func (e *exampleService) Start() error {
	e.ch <- os.Signal(nil)
	<-e.wait
	return nil
}

func (e *exampleService) Close() error {
	close(e.wait)
	return nil
}

func TestServiceRunner(t *testing.T) {
	ch := make(chan os.Signal)
	e := exampleService{
		ch:   ch,
		wait: make(chan struct{}),
	}
	s := ServiceRunner{
		SigChan:  ch,
		Services: []Service{&e},
	}
	err := s.Execute()
	if err != nil {
		t.Error("Expected nil error, got", err)
	}
}
