package spadetest

import (
	"context"
	"testing"

	"code.justin.tv/hygienic/distconf"
	"code.justin.tv/hygienic/spade"
	"code.justin.tv/hygienic/spade/spadedconf"
	. "github.com/smartystreets/goconvey/convey"
)

type testEvent struct {
	Name string
}

func TestSpadeServer(t *testing.T) {
	Convey("With setup", t, func() {
		t := TestingSpadeServer{}
		finishedServing := make(chan struct{})
		go func() {
			_ = t.Start()
			close(finishedServing)
		}()
		var mem distconf.InMemory
		_ = t.SetupDistconf(&mem)
		dconf := &distconf.Distconf{
			Readers: []distconf.Reader{&mem},
		}
		conf := &spadedconf.Config{}
		So(conf.Load(dconf), ShouldBeNil)
		c := spade.Client{
			Config: conf,
		}
		err := c.Setup()
		So(err, ShouldBeNil)
		go func() {
			_ = c.Start()
		}()
		ctx := context.Background()
		So(c.VerifyEndpoint(ctx), ShouldBeNil)

		event := spade.Event{
			Name: "testing_events",
			Properties: testEvent{
				Name: "testing-code",
			},
		}
		err = c.BlockingSendEvents(ctx, event)
		So(err, ShouldBeNil)
		res := <-t.Events
		So(res.Name, ShouldEqual, "testing_events")

		event.Name = "queue_event"
		c.QueueEvents(event)

		res = <-t.Events
		So(res.Name, ShouldEqual, "queue_event")

		So(t.Close(), ShouldBeNil)
		<-finishedServing
		So(c.Close(), ShouldBeNil)
	})
}
