# ttllruerrcache
[![GoDoc](https://img.shields.io/badge/godoc-reference-5272B4.svg?style=flat-square)](https://godoc.internal.justin.tv/code.justin.tv/hygienic/ttllruerrcache)
[![Build Status](https://jenkins.internal.justin.tv/buildStatus/icon?job=hygienic/ttllruerrcache/master)](https://jenkins.internal.justin.tv/job/hygienic/job/ttllruerrcache/job/master/)

Cache values with a TTL (and separate err cache)

# Example

```go
func ExampleCache() {
	c := Cache {
		ItemTTL: time.Second * 60,
	}
	c.Set("hello", "world")
	value, exists := c.Get("hello")
	fmt.Println(value, exists)
	// Output: world true
}
```

The cache also works with default values


```go
func ExampleCache_Defaults() {
	var c Cache
	c.Set("hello", "world")
	value, exists := c.Get("hello")
	fmt.Println(value, exists)
	// Output: world true
}
```