package statsd

import (
	"time"

	"code.justin.tv/hygienic/twirpclienthooks"
	twirphooks "github.com/twitchtv/twirp/hooks/statsd"
)

var _ twirphooks.Statter = &prefixStatter{}

type prefixStatter struct {
	prefix string
	inner  twirphooks.Statter
}

func (p *prefixStatter) Inc(metric string, val int64, rate float32) error {
	return p.inner.Inc(p.prefix+"."+metric, val, rate)
}
func (p *prefixStatter) TimingDuration(metric string, val time.Duration, rate float32) error {
	return p.inner.TimingDuration(p.prefix+"."+metric, val, rate)
}

// NewRoundTripper creates a sub statter from stats to identify the client in statsd metrics.  Appends
// 'client' to all the metrics by default.
func NewRoundTripper(stats twirphooks.Statter) *twirpclienthooks.RoundTripper {
	// Append 'client' to the metrics to differentiate them from server side metrics
	hooks := twirphooks.NewStatsdServerHooks(&prefixStatter{
		prefix: "client",
		inner:  stats,
	})
	return &twirpclienthooks.RoundTripper{
		Hooks: hooks,
	}
}
