package statsdslo_test

import (
	"time"

	"code.justin.tv/hygienic/twirpserviceslohook"
	"code.justin.tv/hygienic/twirpserviceslohook/statsdslo"
	"github.com/cactus/go-statsd-client/statsd"
)

func ExampleStatTracker() {
	var stat *statsd.Client
	tracker := twirpserviceslohook.TwirpSLOTracker{
		SLO: map[twirpserviceslohook.ServiceName]map[twirpserviceslohook.MethodName]time.Duration{
			"Haberdasher": {
				"MakeHat": time.Millisecond * 50,
			},
		},
		DefaultSLO: time.Millisecond * 100,
		StatTracker: &statsdslo.StatTracker{
			Statter: stat,
		},
	}
	tracker.ServerHook()

	// Output:
}
