![Twirp Logo](./logo.png) [![Build Status](https://travis-ci.org/twitchtv/twirp.svg?branch=master)](https://travis-ci.org/twitchtv/twirp) [![Go Report Card](https://goreportcard.com/badge/github.com/twitchtv/twirp)](https://goreportcard.com/report/github.com/twitchtv/twirp) [![GoDoc](https://godoc.org/github.com/twitchtv/twirp?status.svg)](https://godoc.org/github.com/twitchtv/twirp)

---

Twirp is a framework for service-to-service communication emphasizing simplicity
and minimalism. It generates routing and serialization from API definition files
and lets you focus on your application's logic instead of thinking about
folderol like HTTP methods and paths and JSON.

Define your service in a
[Protobuf](https://developers.google.com/protocol-buffers/docs/proto3) file and
then Twirp autogenerates Go code with a server interface and fully functional
clients. It's similar to [gRPC](http://www.grpc.io/), but without the custom
HTTP server and transport implementations: it runs on the standard library's
extremely-well-tested-and-high-performance `net/http` Server. It can run on HTTP
1.1, not just http/2, and supports JSON clients for easy integrations across
languages

Twirp handles routing and serialization for you in a well-tested, standardized,
thoughtful way so you don't have to. Serialization and deserialization code is
error-prone and tricky, and you shouldn't be wasting your time deciding whether
it should be "POST /friends/:id/new" or "POST /:id/friend" or whatever. Just
get to the real work of building services!

Along the way, you get an autogenerated client and a simple, smart framework for
passing error messages. Nice!

For more on the motivation behind Twirp (and a comparison to REST APIs and gRPC), the
[announcement blog post](https://blog.twitch.tv/en/2018/01/16/twirp-a-sweet-new-rpc-framework-for-go-5f2febbf35f/)
is a good read.

### Installation
Use `go get` to install the Go client-and-server generator:

```
go get github.com/twitchtv/twirp/protoc-gen-twirp
```

You will also need:
 - [protoc](https://github.com/protocolbuffers/protobuf), the protobuf compiler. You need
   version 3+.
 - [github.com/golang/protobuf/protoc-gen-go](https://github.com/golang/protobuf/),
   the Go protobuf generator plugin. Get this with `go get`.

### Documentation

Thorough documentation is
[on the website](https://twitchtv.github.io/twirp/docs/intro.html).

Source for this documentation is in the [docs](./docs) subdirectory. The website
is generated from that folder using [Docusaurus](https://docusaurus.io/).

### Implementations in other languages

This repo only has the official generators, which write out Go and
Python (partial, see [#185](https://github.com/twitchtv/twirp/issues/185) and [#220](https://github.com/twitchtv/twirp/issues/220)) code.

For other languages, there are third-party generators available:

|    Language    | Clients | Servers | Repository |
|----------------|---------|---------|------------|
| **Python3**    |    ✓    |    ✓    | [github.com/verloop/twirpy](https://github.com/verloop/twirpy)
| **Java**       |    ✓    |    ✓    | [github.com/fajran/protoc-gen-twirp_java_jaxrs](https://github.com/fajran/protoc-gen-twirp_java_jaxrs)
| **Java**       |         |    ✓    | [https://github.com/devork/flit](https://github.com/devork/flit)
| **JavaScript** |    ✓    |         | [github.com/thechriswalker/protoc-gen-twirp_js](https://github.com/thechriswalker/protoc-gen-twirp_js)
| **JavaScript** |    ✓    |         | [github.com/Xe/twirp-codegens/cmd/protoc-gen-twirp_jsbrowser](https://github.com/Xe/twirp-codegens)
| **Typescript** |    ✓    |         | [github.com/larrymyers/protoc-gen-twirp_typescript](https://github.com/larrymyers/protoc-gen-twirp_typescript)
| **Ruby**       |    ✓    |    ✓    | [github.com/twitchtv/twirp-ruby](https://github.com/twitchtv/twirp-ruby)
| **Rust**       |    ✓    |    ✓    | [github.com/cretz/prost-twirp](https://github.com/cretz/prost-twirp)
| **Swagger**    |    ✓    |    ✓    | [github.com/elliots/protoc-gen-twirp_swagger](https://github.com/elliots/protoc-gen-twirp_swagger)
| **PHP**        |    ✓    |    ✓    | [github.com/twirphp/twirp](https://github.com/twirphp/twirp)
| **Dart**       |    ✓    |         | [github.com/apptreesoftware/protoc-gen-twirp_dart](https://github.com/apptreesoftware/protoc-gen-twirp_dart)

This list isn't an endorsement, it's just a convenience to help you find stuff
for your language.

### Support and Community
We have a channel on the Gophers slack, [#twirp](https://gophers.slack.com/messages/twirp),
which is the best place to get quick answers to your questions. You can join the
Gopher slack [here](https://invite.slack.golangbridge.org/).

### Releases
Twirp follows semantic versioning through git tags, and uses Github Releases for
release notes and upgrade guides:
[Twirp Releases](https://github.com/twitchtv/twirp/releases)

### Contributing
Check out [CONTRIBUTING.md](./CONTRIBUTING.md) for notes on making contributions.

### License

This library is licensed under the Apache 2.0 License.
