const fs = require("fs");
const path = require("path");

const { distDir } = require("./utils");

// Clean
fs.rmdirSync(distDir, { recursive: true });
fs.mkdirSync(distDir);

// Rebuild
require("./month-day-year-order");
require("./number-short");

// Share the locales as source of truth
fs.copyFileSync(
  path.join(__dirname, "../../src/locales.json"),
  path.join(distDir, "locales.json")
);
