const fs = require("fs");
const path = require("path");

const { distDir, getLocaleFile } = require("./utils");

const localesInfo = require("../../src/locales.json");
const cldrRulesByLocale = {};

function getCalendarModule(locale) {
  return `cldr-dates-modern/main/${locale}/ca-gregorian.json`;
}

localesInfo.locales.forEach((locale) => {
  const calendarJson = getLocaleFile(locale, getCalendarModule);
  const shortDateFormat =
    calendarJson.dates.calendars.gregorian.dateFormats.short;

  cldrRulesByLocale[locale] = shortDateFormat
    .replace(/d+/gi, "D")
    .replace(/m+/gi, "M")
    .replace(/y+/gi, "Y")
    .replace(/[^DMY]+/gi, "");
});

fs.writeFileSync(
  path.join(distDir, "month-day-year-order.json"),
  JSON.stringify(cldrRulesByLocale, null, 2)
);
