const path = require("path");
const localesInfo = require("../../src/locales.json");

function stripWrapingObj(module) {
  const tmpLocale = Object.keys(module.main)[0];
  return module.main[tmpLocale];
}

module.exports = {
  distDir: path.join(__dirname, "../../dist"),
  /**
   * Attempts to return given data for locale-LANG, but if fails
   * will attempt to drop the language specifier and return
   * the given file for the base locale.
   * @param locale {string}
   * @param getModulePath {(locale: string) => string} returns a path to require, given a locale
   */
  getLocaleFile(locale, getModulePath) {
    const modulePath = getModulePath(locale);
    try {
      require.resolve(modulePath);
      // Module was found, return as-is
      return stripWrapingObj(require(modulePath));
    } catch (e) {
      locale = locale.substring(0, 2);
      return stripWrapingObj(
        require(getModulePath(
          localesInfo.cldrLocaleOverrides[locale] || locale
        ))
      );
    }
  },
};
