/*
 * grunt-smartling-sdk
 * https://github.com/hightail/grunt-smartling-sdk
 *
 * Copyright (c) 2014 Hightail
 * Author: Justin Fiedler
 *
 * Licensed under the ISC license.
 */

'use strict';

var I18N_CONFIG_FILE = './test/i18n.config.json';

module.exports = function (grunt) {
  // load all npm grunt tasks
  require('load-grunt-tasks')(grunt);

  if (!grunt.file.exists(I18N_CONFIG_FILE)) {
    grunt.fail.fatal('Confirm i18n.config.json exists');
  }

  var i18nConfig = grunt.file.readJSON(I18N_CONFIG_FILE);

  var uploadSourceI18nConfig = require('lodash').assign(
      {},
      i18nConfig,
      {
        sourcePath: "./test/fixtures/source-en-us.yaml"
      }
  );

  grunt.option('stack', true);

  // Project configuration.
  grunt.initConfig({
    jshint: {
      all: [
        'Gruntfile.js',
        'tasks/*.js',
        'lib/**/*.js',
        'test/**/*.js'
      ],
      options: {
        jshintrc: '.jshintrc',
        reporter: require('jshint-stylish')
      }
    },

    // Before generating any new files, remove any previously-created files.
    clean: {
      default: ['test/tmp/translations', 'test/tmp/build-translations']
    },

    'build-get-translations': {
      options: {
        operation: {
          locale: 'en',
          retrievalType: 'published',
          includeOriginalStrings: 'false'
        },
        i18n: i18nConfig
      },
      default: {}
    },

    'submit': {
      options: {
        i18n: i18nConfig,
        operation: {
        }
      },
      default: {}
    },

    'get-latest': {
      options: {
        operation: {
          retrievalType: 'published',
          includeOriginalStrings: 'false'
        },
        i18n: i18nConfig
      },
      default: {}
    },

    'upload-source': {
      options: {
        i18n: i18nConfig,
        operation: {
        }
      },
      test: {
        options: {
          i18n: uploadSourceI18nConfig
        }
      }
    },

    'build-clear-cache': {
      options: {
        i18n: i18nConfig,
        operation: {
        }
      },
      default: {}
    },

    nodeunit: {
      all: [
        'test/*-test.js'
      ]
    }
  });

  // Actually load this plugin's task(s).
  grunt.loadTasks('tasks');

  // Whenever the "test" task is run, first clean the "tmp" dir, then run this
  // plugin's task(s), then test the result.
  grunt.registerTask('test', ['clean', 'jshint:all', 'nodeunit']);

  // By default, lint and run all tests.
  grunt.registerTask('default', ['help']);

  grunt.registerMultiTask('build', 'Run all my build tasks.', function(n) {
    console.log(n);
    if (n == null) {
      grunt.warn('Build num must be specified, like build:001.');
    }
  });

};
