
# Note
This is a fork of [grunt-smartling-sdk](https://github.com/hightail/grunt-smartling-sdk) heavily modified for Twitch's I18n needs. The rest of the README may not be up to date.

In [`sampleConfigs/`](sampleConfigs/) there are templates for `Gruntfile.js` and `i18n.config.json` that are required.

Differences:
* Re-wrote all the tasks for what we need internally
* Tasks will automatically convert to and from json/yaml formats as expected
* Added common functions/classes that are used by tasks

> Grunt tasks for smartling-sdk

## Getting Started
This plugin requires Grunt.

If you haven't used [Grunt](http://gruntjs.com/) before, be sure to check out the [Getting Started](http://gruntjs.com/getting-started) guide, as it explains how to create a [Gruntfile](http://gruntjs.com/sample-gruntfile) as well as install and use Grunt plugins. Once you're familiar with that process, you may install this plugin with this command:

```shell
npm install grunt-smartling-sdk
```

Once the plugin has been installed, it may be enabled inside your Gruntfile with this line of JavaScript:

```js
grunt.loadNpmTasks('grunt-smartling-sdk');
```

## The "smartling_sdk" task

### Overview
In your project's Gruntfile, add a section for each task you want to use in `grunt.initConfig()`.

```js
grunt.initConfig({
  smartling_list: {
    options: {
      // Task-specific options go here.
      smartling: {
        apiBaseUrl: SmartlingSdk.API_BASE_URLS.SANDBOX,
        apiKey: '',
        projectId: ''
      }
    },
    your_target: {
      // Target-specific file lists and/or options go here.
    },
  }
})
```

### Options

#### options.smartling
Type: `Object`
Default value: `None`

An object with your Smartling API and Project settings. This is require for all smartling tasks

```js
{
  apiBaseUrl: SmartlingSdk.API_BASE_URLS.LIVE,
  apiKey: 'your-api-key',
  projectId: 'your-project-id'
}
```

#### options.operation
Type: `Object`
Default value: `None`

A object that is used to set Smartling options for a given operation (status, get, upload, etc).

Example options.operation for `smartling_upload`

```js
{
  fileType: 'json',
  approved: false
}
```

## Contributing
In lieu of a formal styleguide, take care to maintain the existing coding style. Add unit tests for any new or changed functionality. Lint and test your code using [Grunt](http://gruntjs.com/).

## Release History
_(Nothing yet)_

## License
Copyright (c) 2014 Hightail. Licensed under the ISC license.

NOTES

Sometimes instead of Error instances being returned, just objects are. So I have to catch them in various places. More investigation needed.
