/*
 * grunt-smartling-sdk
 * https://github.com/hightail/grunt-smartling-sdk
 *
 * Copyright (c) 2014 Hightail
 * Author: Justin Fiedler
 *
 * Licensed under the ISC license.
 */

'use strict';
var path = require('path');

var defaultI18nConfigPath = './i18n/i18n.config.json';

module.exports = function (grunt) {
  // load all npm grunt tasks. Not needed for client code
  // require('load-grunt-tasks')(grunt);

  var i18nConfigPath = grunt.option('i18nConfigPath') || defaultI18nConfigPath;
  var prefix = path.dirname(require.resolve('grunt-smartling-sdk-twitch'));
  if (!i18nConfigPath || !grunt.file.exists(i18nConfigPath)) {
    grunt.fail.fatal('Confirm i18n.config.json exists');
  }

  var i18nConfig = grunt.file.readJSON(i18nConfigPath);
  grunt.verbose.writeln('Using i18nConfig from: ' + i18nConfigPath);

  grunt.option('stack', true);

  // Project configuration.
  grunt.initConfig({
    'build-get-translations': {
      options: {
        operation: {
          locale: 'en',
          retrievalType: 'published',
          includeOriginalStrings: 'false'
        },
        i18n: i18nConfig
      },
      default: {}
    },

    'submit': {
      options: {
        i18n: i18nConfig,
        operation: {
        }
      },
      default: {}
    },

    'get-latest': {
      options: {
        operation: {
          retrievalType: 'published',
          includeOriginalStrings: 'false'
        },
        i18n: i18nConfig
      },
      default: {}
    },

    'upload-source': {
      options: {
        i18n: i18nConfig,
        operation: {
        }
      },
      test: {
        options: {
          i18n: i18nConfig
        }
      }
    },

    'build-clear-cache': {
      options: {
        i18n: i18nConfig,
        operation: {
        }
      },
      default: {}
    }
  });

  // Actually load this plugin's task(s).
  grunt.loadTasks(prefix + '/tasks');

  // Whenever the "test" task is run, first clean the "tmp" dir, then run this
  // plugin's task(s), then test the result.
  grunt.registerTask('test', ['clean', 'jshint:all', 'nodeunit']);

  // By default, lint and run all tests.
  grunt.registerTask('default', ['help']);

  grunt.registerMultiTask('build', 'Run all my build tasks.', function(n) {
    console.log(n);
    if (n == null) {
      grunt.warn('Build num must be specified, like build:001.');
    }
  });

};
