var SmartlingSdk = require('./smartling-sdk.js');

/**
 * Sets up common settings for Smartling tasks
 *
 * @param taskFunction
 * @returns {Function}
 */
var make = function(taskFunction) {
  process.on('unhandledRejection', function(error /*, promise */) {
    console.log(error);
    console.error("UNHANDLED REJECTION", error.stack);
  });
  
  return function() {
    var done = this.async();

    // Merge task-specific and/or target-specific options with these defaults.
    var options = this.options(this.data);

    if (!options.operation) {
      options.operation = {};
    }

    var sdk = new SmartlingSdk(
        options.i18n.serviceUrl + '/smartling-v2-proxy/',
        options.i18n.projectId);

    taskFunction(this, options, sdk, done);
  };
};

module.exports = {
  make: make
};