'use strict';

module.exports = function (grunt) {
  var asyncUtil     = require('async'),
      SmartlingTask = require('../lib/smartling-task'),
      _             = require('lodash'),
      readlineSync  = require('readline-sync'),
      chalk         = require('chalk'),
      commonMethods = require('./../lib/common-methods.js');

  grunt.registerMultiTask('get-latest', 'Updates all translations from Smartling',
      SmartlingTask.make(function (task, options, sdk, done) {
        commonMethods.setI18nType(grunt, options.i18n);

        grunt.log.subhead('This might take up to 30 seconds to complete.');

        asyncUtil.series([
          function checkVersion(callback) {
            commonMethods.checkVersion(grunt, options, callback);
          },
          function confirmBaseLocaleFileExists(callback) {
            var fileUri = commonMethods.formatFileName(options.i18n.baseLocale, options.i18n.fileType);

            commonMethods.confirmFileExists(sdk, grunt, options, fileUri, function (error, doesFileExist) {
              if (error) {
                grunt.log.writeln(JSON.stringify(error));
                return callback(error);
              }

              if (doesFileExist) {
                grunt.verbose.writeln('Base File Does exist in Smartling');
                return callback();
              } else {
                grunt.log.error(fileUri + ' does not exist in Smartling, run script to update base file');
                return callback(new Error('Base File Does Not Exist'));
              }
            });
          },

          function getTranslations(callback) {
            commonMethods.getTranslations(sdk, grunt, options, callback);
          }
        ], function (error) {
          if (error) {
            return done(error);
          }

          return done();
        });
      })
  );
};