'use strict';

/*
 * grunt-smartling-sdk
 * https://github.com/hightail/grunt-smartling-sdk
 *
 * Copyright (c) 2014 Hightail
 * Author: Justin Fiedler
 *
 * Licensed under the ISC license.
 */

module.exports = function (grunt) {
  var SmartlingTask = require('../lib/smartling-task'),
      readlineSync  = require('readline-sync'),
      chalk         = require('chalk'),
      _             = require('lodash'),
      commonMethods = require('./../lib/common-methods.js');

  grunt.registerMultiTask('upload-source', 'Upload the source file to Smartling',
      SmartlingTask.make(function (task, options, sdk, done) {
        if (process.env.CI) {
          if (process.env.GIT_BRANCH !== 'origin/master') {
            grunt.log.writeln('Not uploading source file because branch is not origin/master');
            grunt.log.writeln('Branch: ' + process.env.GIT_BRANCH);
            return done();
          }
        } else {
          var uploadFileConfirmMsg = 'Should upload base translation file to Smartling? (note: this should be done on master branch) [y/N] ';
          var uploadFileConfirm = readlineSync.question(chalk.bold(uploadFileConfirmMsg));
          if (uploadFileConfirm.toLowerCase() !== 'y') {
            return done(grunt.util.error('Did Nothing'));
          }
        }

        var i18nType = commonMethods.setI18nType(grunt, options.i18n);

        var fileContents = i18nType.convertToSmartlingFormat({fileStr: i18nType.getSourceFileStr()});
        grunt.verbose.subhead('Submitting to Smartling:');
        grunt.verbose.write(fileContents);

        commonMethods.uploadSource(sdk, grunt, options, done);
      })
  );
};