var path = require('path'),
    exec = require('child_process').exec,
    execOptions = {
      cwd: path.join(__dirname, '..')
    },
    asyncUtil = require('async'),
    fs = require('fs');

exports.buildGetTranslations = {
  buildGetTranslations: function(test) {
    test.expect(2);

    var I18N_CONFIG_FILE = './test/i18n.config.json';
    var i18nConfig = JSON.parse(fs.readFileSync(I18N_CONFIG_FILE));

    asyncUtil.waterfall([
      function clean(callback) {
        exec('grunt clean', execOptions, function (err, stdout, stderr) {
          if (err) {
            console.log(stdout);
            console.error(stderr);
            return callback(err);
          }

          return callback();
        });

      },
      function buildGetTranslations(callback) {
        exec('CI=true grunt build-get-translations --confirm=y', execOptions, function(error, stdout, stderr) {
          if (error) {
            console.log(stdout);
            console.error(stderr);
          }

          test.ok(true, 'Successfully submitted');
          return callback();
        });
      },
      function confirmFiles(callback) {
        var dirInfo = fs.readdirSync(i18nConfig.buildTranslationsDirectory);
        test.strictEqual(dirInfo.length, i18nConfig.locales.length, 'Number of files downloaded matched');

        return callback();
      }
    ], function (error) {
      if (error) {
        console.log('There was an error: ', error);
      }

      test.done();
    });

  }

};