var path = require('path'),
    exec = require('child_process').exec,
    execOptions = {
      cwd: path.join(__dirname, '..')
    },
    asyncUtil = require('async'),
    fs = require('fs');

exports.getLatest = {
  getLatest: function(test) {
    test.expect(3);

    var I18N_CONFIG_FILE = './test/i18n.config.json';
    var i18nConfig = JSON.parse(fs.readFileSync(I18N_CONFIG_FILE));

    asyncUtil.waterfall([
      function clean(callback) {
        exec('grunt clean', execOptions, function (err, stdout, stderr) {
          if (err) {
            console.log(stdout);
            console.log(stderr);
            return callback(err);
          }

          test.ok(true, 'Grunt clean was successful');

          return callback();
        });

      },
      function getLatestTranslations(callback) {
        exec('CI=true grunt get-latest --confirm=y', execOptions, function(error, stdout, stderr) {
          if (error) {
            console.log(stdout);
            console.error(stderr);
            return callback(error);
          }

          test.ok(true, 'Successfully submitted');
          return callback();
        });
      },
      function confirmFiles(callback) {
        if (!fs.existsSync('./test/tmp/translations')) {
          return callback(new Error('Folder Not Found'));
        }
        var dirInfo = fs.readdirSync('./test/tmp/translations');
        // Minus one because get-latest does NOT overwrite the base locale
        test.strictEqual(dirInfo.length, i18nConfig.locales.length - 1, 'Number of files downloaded matched');

        return callback();
      }
    ], function (error) {
      if (error) {
        console.log('There was an error: ', error);
      }

      test.done();
    });

  }

};