var path = require('path'),
    exec = require('child_process').exec,
    execOptions = {
      cwd: path.join(__dirname, '..')
    },
    asyncUtil = require('async'),
    fs = require('fs');

exports.gruntSubmit = {
  submitTranslationFile: function(test) {
    test.expect(2);

    asyncUtil.waterfall([
      function submit(callback) {
        exec('grunt submit --localDiff --ticket=LOC-229 --confirmSubmit=y --confirmOverwrite=y --skipCallbackUrl=true --failOnError=true', execOptions, function(error, stdout, stderr) {
          if (error) {
            console.log(stdout);
            console.error(stderr);
            return callback(error);
          }

          test.ok(true, 'Successfully submitted');
          return callback();
        });
      }
    ], function (error) {
      if (error) {
        console.log('There was an error: ', error);
      } else {
        test.ok(true, 'No errors in test suite');
      }

      test.done();
    });

  }

};