var path = require('path'),
    exec = require('child_process').exec,
    execOptions = {
      cwd: path.join(__dirname, '..')
    },
    asyncUtil = require('async');

exports.gruntSubmit = {
  submitTranslationFile: function(test) {
    test.expect(3);

    asyncUtil.waterfall([
      function uploadSource(callback) {
        // This resets the smartling's en-us to the expected value
        exec('CI=true GIT_BRANCH=origin/master grunt upload-source:test', execOptions, function(error, stdout, stderr) {
          if (error) {
            console.log(stdout);
            console.error(stderr);
            return callback(error);
          }

          test.ok(true, 'Successfully Uploaded Source');
          return callback();
        });

      },
      function submit(callback) {
        exec('grunt submit --ticket=LOC-229 --confirmSubmit=y --confirmOverwrite=y --skipCallbackUrl=true --failOnError=true', execOptions, function(error, stdout, stderr) {
          if (error) {
            console.log(stdout);
            console.error(stderr);
            return callback(error);
          }

          test.ok(true, 'Successfully submitted');
          return callback();
        });
      }
    ], function (error) {
      if (error) {
        console.log('There was an error: ', error);
      } else {
        test.ok(true, 'No errors in test suite');
      }

      test.done();
    });

  }

};