# i18n-service


## Summary

Uses:
* Proxy for Smartling requests so devs/scripts don't need to commit tokens/secrets (Supports Smartling APIs V1 and V2)
* Build endpoint: caches Smartling assets for a project with a TTL. Has some other necessary endpoints as well: client error logging, creating JWT token for I18n Service Callback, viewing in-memory and S3 caches, and fetching translations.
* Endpoint to add comments to a JIRA ticket. This is used by grunt scripts to add list of strings that were uploaded for a ticket.
* Smartling Callback Endpoint: This is called by I18n-Callback-Service to clear the cache when files are updated.

## How to run locally:

`ENVIRONMENT=development rerun 'bundle exec rackup'` to start project and rebuild on file changes.

## Notes:

* Smartling v2 API uses account-level token
* Smartling v1 API needs to have every desired project type configured in 'smartlingConfig'
* [List of Sandstorm secrets](https://git-aws.internal.justin.tv/i18n/i18n-service/tree/master/deploy/.ebextensions/data/sandstorm-agent/templates.d). New devs would probably have to ssh into prod and make copies of secrets for local dev.
* [I18n Service on Rollbar](https://rollbar.com/Twitch/I18n-Service/)
* I18n LDAP group was used for Sandstorm and CNAME changes
* Use `./scripts/ssh-staging-staging.sh` and `./scripts/ssh-production-production.sh` to ssh into the environments.
* This uses [TCS](https://git-aws.internal.justin.tv/dta/tcs) and uses the [Docker-Elastic-Beanstalk](https://git-aws.internal.justin.tv/dta/docker-eb-tf-skeleton) and [Ruby-HTTP](https://git-aws.internal.justin.tv/dta/ruby-http-skeleton) skeletons
* JIRA Tokens were created with [jira_oauth_dance.py](https://git-aws.internal.justin.tv/security/sirtjira/tree/master/scripts). Jira Account: `SRVC-LOC-JIRA`


AWS

* This and [I18n-Smartling-Callback](https://git-aws.internal.justin.tv/i18n/i18n-smartling-callback) are deployed on twitch-web-aws and twitch-web-dev
* This service uses an S3 bucket: `i18n-twitch-prod` and `i18n-twitch-staging`
* The IP whitelist rules for Smartling-Callback were created manually. Smartling: 184.73.255.141 From Work: 98.234.114.18/32   
* Both services use ELBs (as in normal for TCS-created services)
* Notice the Keypair and IAM roles in the configuration

DNS Changes

- i18n-service-dev.internal.justin.tv CNAME which points to staging-i18n-i18n-service-env.hmnjfik6dt.us-west-2.elasticbeanstalk.com
- i18n-service.internal.justin.tv CNAME points to production-i18n-i18n-service-env.ssjnpsztba.us-west-2.elasticbeanstalk.com

## URLs
If the page says "Forbidden", try forcing `http://`

||Production|Staging|
|---|---|---|
|URL|[i18n-service.internal.justin.tv](https://i18n-service.internal.justin.tv)|[i18n-service-dev.internal.justin.tv](https://i18n-service-dev.internal.justin.tv)|
|S3 Cache|[i18n-service.internal.justin.tv/api/build/v1/s3](https://i18n-service.internal.justin.tv/api/build/v1/s3)|[i18n-service-dev.internal.justin.tv/api/build/v1/s3](http://i18n-service-dev.internal.justin.tv/api/build/v1/s3)|
|In Memory Cache|[i18n-service.internal.justin.tv/api/build/v1/cache](http://i18n-service.internal.justin.tv/api/build/v1/cache)|[i18n-service-dev.internal.justin.tv/api/build/v1/cache](http://i18n-service-dev.internal.justin.tv/api/build/v1/cache)|

* [Service Status Page](https://status.internal.justin.tv/services/61)


