require 'json'

module Utils
	def self.get_config_file(sandstorm_file_name)
		return JSON.parse(self.get_config_file_raw(sandstorm_file_name))
	end

	def self.get_config_file_raw(sandstorm_file_name)
		file_name = self.get_config_file_path(sandstorm_file_name)
		if File.file? file_name
			return File.read(file_name)
		else
			raise "#{sandstorm_file_name} does not exist"
		end
	end

	def self.get_config_file_path(sandstorm_file_name)
		folder_name = (ENV['ENVIRONMENT'] == 'development') ? './sandstorm-keys/' : '/var/app/'
		file_name = folder_name + sandstorm_file_name
		return file_name
	end

end