

module "bs-production" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-web-aws"
  aws_region = "us-west-2"
  eb_application_name = "${module.bs-app-production.beanstalk_application_name}"
  vpc_id = "vpc-f44c0c91"
  ec2_subnet_ids = "subnet-18f2866f"
  elb_subnet_ids = "subnet-18f2866f"
  elb_loadbalancer_security_groups = "sg-62c3f31a"
  elb_loadbalancer_https_port = "443"
  elb_loadbalancer_ssl_port_protocol = "HTTPS"
  elb_loadbalancer_ssl_certificate_id = "arn:aws:acm:us-west-2:641044725657:certificate/a4ee0af5-7d54-470b-8e47-ff778272835a"
  auto_scaling_lc_security_groups = "sg-62c3f31a"
  solution_stack_name = "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
  auto_scaling_lc_keypair_name = "vidhurv"
  auto_scaling_lc_instance_type = "t2.micro"
  owner = "vidhurv@twitch.tv"
  service = "i18n/i18n-service"
  env = "production"
  associate_public_address = "false"

  env_rack_env = "production"
}
