

module "bs-staging" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-web-dev"
  aws_region = "us-west-2"
  eb_application_name = "${module.bs-app-staging.beanstalk_application_name}"
  vpc_id = "vpc-230f5e46"
  ec2_subnet_ids = "subnet-b0af88d5"
  elb_subnet_ids = "subnet-b0af88d5"
  elb_loadbalancer_security_groups = "sg-c06b03a4"
  elb_loadbalancer_https_port = "443"
  elb_loadbalancer_ssl_port_protocol = "HTTPS"
  elb_loadbalancer_ssl_certificate_id = "arn:aws:acm:us-west-2:465369119046:certificate/2fdc659f-0a21-4df6-90d4-65a0d955728d"
  auto_scaling_lc_security_groups = "sg-c06b03a4"
  solution_stack_name = "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
  auto_scaling_lc_keypair_name = "vidhurv"
  auto_scaling_lc_instance_type = "t2.micro"
  owner = "vidhurv@twitch.tv"
  service = "i18n/i18n-service"
  env = "staging"
  associate_public_address = "false"

  env_rack_env = "staging"
}
