require 'rest-client'

I18N_SERVICE_URLS = {
	'development' => 'http://localhost:9292',
	'staging' => 'http://staging-i18n-i18n-service-env.hmnjfik6dt.us-west-2.elasticbeanstalk.com',
	'production' => 'http://production-i18n-i18n-service-env.ssjnpsztba.us-west-2.elasticbeanstalk.com'
}
module I18nsmartlingcallback
	class Backend
		def initialize
			if I18N_SERVICE_URLS.has_key? ENV['ENVIRONMENT']
				@i18nServiceUrl = I18N_SERVICE_URLS[ENV['ENVIRONMENT']]
			else
				raise 'Invalid environment'
			end

			if ENV['ENVIRONMENT'] == 'development'
				RestClient.log = 'stdout'
			end
		end

		def get_url()
			@i18nServiceUrl
		end
	end
end
