require 'rollbar'
require 'rest-client'

module I18nsmartlingcallback
	class Server < TwitchSinatra::Base
		namespace '/api-v1' do
			get '/*' do
				rollbarParams = {}
				
				begin
					url = settings.backend.get_url()
					i18n_service_url = url + '/api/build/v1/smartling-callback/' + request.path['/api-v1/'.length..-1]

					projectId = params['splat'][2]
					fileUri = params['fileUri']
					locale = params['locale']
					
					rollbarParams = {
						:projectId => projectId,
						:fileUri => fileUri,
						:locale => locale
					}

					RestClient.get(i18n_service_url, params: params.except('splat', 'captures')) {
						|response, request, result|
						if response.code != 200
							puts 'Error with callback: ' + response.code.to_s
							raise 'Error with I18n Service'
						end
					}

				rescue Exception => e
					puts "Error during processing: #{$!}"
					puts "Backtrace:\n\t#{e.backtrace.join("\n\t")}"
					Rollbar.error(e, rollbarParams)
					halt 500
				end

				Rollbar.info('I18n-Smartling-Callback', rollbarParams)
				halt 200
			end
		end

		get '/*' do
			halt 404
		end
		
	end
end
