#!/bin/bash

set -e

ACCOUNT=$1

case "$ACCOUNT" in
        staging)
            ENVIRONMENTS=(staging)
            ;;
        production)
            ENVIRONMENTS=(production)
            ;;
        *)
            echo "Unknown account \"$ACCOUNT\", exiting"
            exit 1
esac

for ENVIRONMENT in "${ENVIRONMENTS[@]}"
do
    ROLE=`terraform output -state=./terraform/${ACCOUNT}/.terraform/terraform.tfstate ${ENVIRONMENT}-iam_role_arn`

    tcs sandstorm role-flags \
        --owner team-i18n \
        --name i18n-${ENVIRONMENT}-i18n-smartling-callback \
        --secret_key "i18n/i18n-smartling-callback/${ENVIRONMENT}/*" \
        --allowed_arn "${ROLE}" \
        --output ./sandstorm.d/${ACCOUNT}_${ENVIRONMENT}.json

done
