module.exports = {
    root: true,
    parserOptions: {
        ecmaVersion: 6,
        sourceType: 'module'
    },
    plugins: ['ember-rules'],
    extends: 'eslint:recommended',
    env: {
        'node': true
    },
    rules: {
        // Rules removed from eslint:recommended
        'indent': [0, 2],

        // Rules added beyond eslint:recommended
        'arrow-spacing': [2, { 'before': true, 'after': true }],
        'camelcase': [2, { properties: 'never' }],
        'curly': [2, 'all'],
        'eol-last': 2,
        'eqeqeq': 2,
        'linebreak-style': 2,
        'no-caller': 2,
        'no-case-declarations': 2,
        'no-eq-null': 2,
        'no-eval': 2,
        'no-multi-str': 2,
        'no-new': 2,
        'operator-linebreak': [2, 'after'],
        'semi': 2,
        'space-in-parens': [2, 'never'],
        'space-unary-ops': [2, { 'words': false, 'nonwords': false }],

        // Ember Rules
        "ember-rules/destructure-namespaces": [1, ["Ember", "DS"]],
        "ember-rules/no-function-prototype-extension-calls": 1,

        // Warnings added. These are issues to be fixed up
        // as commits are made to reduce incidents until they can be
        // completely fixed and moved into errors
        'comma-dangle': 1,
        'no-console': 1,
        'no-else-return': 1,
        'no-shadow': 1,
        'no-var': 1,
        'prefer-spread': 1,
        'prefer-template': 1
    }
};
