## Dev Notes

### File Formats Terminology:

**SmartlingFormat:** includes comments above, plural/one/other

**PropSchema:** includes comments, phrase, noTranslate

**KeyString:** key => ICU string


### Where Conversions Happen:

**Submit:**

PropSchema => SmartlingFormat. Handled by print-yaml

**Get-Ticket:**

SmartlingFormat => PropSchema: Handled by SmartlingToPropSchema which deals with plural/one/other
And then merge left: [English, Current Locale Translations, New Ticket Translations]

**Get-Latest/Build-Get-Translations:**

On Upload: PropSchema => SmartlingFormat. Handled by print-yaml

On Download: smartlingToPropSchema

**Ember-Intl:**

propSchema => KeyString. Handled by extractPhrase (just extracts phrase property)

### Smartling YAML for ICU Messages

Sample format created:
```
# CopyButton comment
'[CopyButton] copied': copied
'[VideoDeleteModal] {viewCount, plural, one {# View} other {# Views}}':
  # video delete modal comment
  one: '# View'
  other: '# Views'
# smartling.sltrans = notranslate
pluralKeys:
  '[VideoDeleteModal] {viewCount, plural, one {# View} other {# Views}}': viewCount
# smartling.sltrans = translate
```

Notice: comments on the previous line, splitting plural messages into one/other, and `pluralKeys` object that's surrounded by `notranslate` (this is used to merge back the ICU string when converting back to JSON).
