const deap = require('deap/shallow');
const _ = require('lodash');

const { isObject } = require('./utils.js');

/**
 * Gives all the new keys in s1 that aren't in s2
 * @param {object} s1
 * @param {object} s2
 * @returns {*}
 */
function diffObjects(s1, s2) {
  if (!isObject(s1) || !isObject(s2)) {
    return s1;
  }

  Object.keys(s2).forEach(function (key) {
    if (key in s1 && key in s2) {
      delete s1[key];
    }
  });

  return s1;
}

function mergeObjects(stringsYamlObj, translationYamlObj, newTranslationsObj) {
  let keysWithNull = setValuesToNull(stringsYamlObj);

  return deap.update(keysWithNull, translationYamlObj, newTranslationsObj);
}

/**
 * Sets all values to null. Mutates in place!
 * @param {object.<string, object|string>} obj
 * @returns {object.<string, null>}
 */
function setValuesToNull(obj) {
  return _.mapValues(obj, () => null);
}

/**
 *
 * @param {object[]} objArr
 * @returns {*}
 */
function getKeysInCommon(objArr) {
  if (objArr.length === 0){
    return {};
  }

  if (objArr.length === 1) {
    return objArr[0];
  }

  return objArr.reduce(function (prev, curr) {
    return getKeysInCommonHelper(prev, curr);
  });
}

function getKeysInCommonHelper(first, second) {
  if (!isObject(first) || !isObject(second)) {
    return {};
  }

  let resultObj = {};

  Object.keys(first).filter(function (key) { 
    if (second.hasOwnProperty(key)) {
      resultObj[key] = null;
    }
  });

  return resultObj;
}

module.exports = {
  diffObjects,
  mergeObjects,
  getKeysInCommon,
  setValuesToNull
};
