const _ = require('lodash');

const { isObject, dumpYaml } = require('./utils.js');
const { getICUPluralParts } = require('./yaml-convert.js');
const numIndents = 2;
/**
 * This is used to create a Smartling file that is submitted
 * Returns array of strings from yaml/comment objects
 * @param yamlObj
 * @returns {string}
 */
function main(yamlObj) {
  let resultArray = [];
  printKeyWithComment(yamlObj, resultArray);

  return resultArray.join('\n');
}

function printDoNotTranslate(key, value, arr) {
  arr.push(`${makeSpaces(numIndents)}# smartling.sltrans = notranslate`);
  arr.push(`${makeSpaces(numIndents)}${key}: ${value}`);
  arr.push(`${makeSpaces(numIndents)}# smartling.sltrans = translate`);
}

/**
 * @param {?Object} yamlObj
 * @param {Array.<string>} resultsArray
 */
function printKeyWithComment(yamlObj, resultsArray) {
  if (!isObject(yamlObj)) {
    return;
  }

  let pluralKeys = {};

  Object.keys(yamlObj).forEach(function (key) {
    let obj = yamlObj[key];

    if (!obj.phrase) {
      return;
    }
    let icuPluralParts = getICUPluralParts(obj.phrase);

    if (icuPluralParts === null) {
      if (_.has(obj, 'comment')) {
        resultsArray.push(`# ${obj.comment}`);
      }

      // Doing this to preserve YAML formatting of key and values
      let tmpObj = {};
      tmpObj[key] = obj.phrase;
      let yamlStrs = dumpYaml(tmpObj).replace(/\n$/, '').split('\n');

      yamlStrs.forEach((elem) => {
        resultsArray.push(elem);
      });

    } else {
      let tmpObj = {};
      tmpObj[key] =  {
        one: icuPluralParts.one,
        other: icuPluralParts.other
      };
      let yamlStrs = dumpYaml(tmpObj).replace(/\n$/, '').split('\n');
      resultsArray.push(yamlStrs.shift());

      pluralKeys[key] = icuPluralParts.plural;

      if (_.has(obj, 'comment')) {
        resultsArray.push(`  # ${obj.comment}`);
      }

      yamlStrs.forEach((elem) => {
        resultsArray.push(elem);
      });
    }
  });

  if (Object.keys(pluralKeys).length > 0) {
    resultsArray.push(`# smartling.sltrans = notranslate`);
    resultsArray.push(`pluralKeys:`);
    Object.keys(pluralKeys).forEach((key) => {
      let obj = {};
      obj[key] = pluralKeys[key];
      let yamlStrs = dumpYaml(obj).replace(/\n$/, '').split('\n');

      yamlStrs.forEach((elem) => {
        resultsArray.push(`  ${elem}`);
      });
    });
    resultsArray.push(`# smartling.sltrans = translate`);
  }
}

/**
 * @param {number} num
 * @returns {string}
 */
function makeSpaces(num) {
  return ' '.repeat(num);
}

module.exports = main;
