const { runLints } = require('./linters.js');

const { extractPhrase, insertPhraseProperty } = require('./yaml-convert.js');
const yamlIcu = require('./yaml-icu.js');

/**
 * Prints a smartling file format
 * @param jsonObj Property Schema is expected
 * @returns {Object.<string, string>}
 */
function toSmartlingFormat(jsonObj) {
  return yamlIcu.toSmartlingFormat(insertPhraseProperty(jsonObj));
}

function fromSmartlingFormat(origYamlObj) {
  return extractPhrase(yamlIcu.fromSmartlingFormat(origYamlObj));
}

function lintCheck(jsonObj) {
  let errMsgs = Object.keys(jsonObj).map((elem) => {
    try {
      let obj = {};
      obj[elem] = jsonObj[elem];
      runLints(insertPhraseProperty(obj));
      return null;
    } catch (err) {
      return err.message;
    }
  }).filter(elem => elem !== null);

  if (errMsgs.length > 0) {
    throw new Error(errMsgs.join('\n'));
  }
}

module.exports = {
  toSmartlingFormat,
  fromSmartlingFormat,
  lintCheck
};
